model Ex2_27
import Modelica.Constants.*;
parameter Real T1(unit = "K")=573"Temperature of hot gas";
parameter Real T2(unit = "K")=323"Temperature of insulation";
parameter Real T3(unit = "K")=298"Surrounding temperature";
parameter Real h1(unit = "W/sq m.K")=29" inside heat transfer coefficients";
parameter Real h2(unit = "W/sq m.K")=12" Outside heat transfer coefficients";
parameter Real r1(unit = "m")=0.047"Internal radius ";
parameter Real r2(unit = "m")=0.05"Outer radius";
parameter Real k1(unit = "W/m.K")=58 "Thermal conductivity for ID";
parameter Real k2(unit = "W/m.K")=0.052"Thermal conductivity for ID";
Real r3(unit = "m")"radius of insulation ";
Real t(unit = "m")"Thickness of insulation ";
Real Q_by_l(unit = "W/m")"Rate oh heat loss per unit length";
equation
(T1-T2)/(1/(r1*h1)+log(r2/r1)/k1+log(r3/r2)/k2)=(T2-T3)/(1/(r3*h2));
t=r3-r2;             
Q_by_l=h2*2*pi*r3*(T2-T3);      
//Ans varies slightly due to approximation in book
end Ex2_27;
