model Ex2_3
import Modelica.Constants.*;
parameter Real r1(unit="m")=(88/(2*1000))"Outer radius of pipe"; 
parameter Real t2(unit="m")=30/1000"Thickness of layer 1";
parameter Real t1(unit="m")=50/1000"Thickness of layer 2" ; 
parameter Real T1(unit="K")=623"Temperature at outer surface of wall";  
parameter Real T3(unit="K")=313"Temperature at outer surface of outer insulation";  
parameter Real k1(unit="W/m.K")=0.087"Thermal conductivity of insulation layer 1";  
parameter Real k2(unit="W/m.K")=0.064"Thermal conductivity of insulation layer 2";
parameter Real l(unit="m")=1"Length of pipe"; 
Real r2(unit="m")"radius of layer 1";
Real r3(unit="m")"radius of layer 2";    
Real rm1(unit="m")"Log mean radius of insulation layer-1 ";
Real rm2(unit="m")"Log mean radius of insulation layer-2 ";
Real Q(unit="W/m")"Rate of heat loss"; 
equation
r2=r1+t1;
r3=r2+t2;
rm1=(r2-r1)/log(r2/r1);
rm2=(r3-r2)/log(r3/r2);
Q=(T1-T3)/((r2-r1)/(k1*2*pi*rm1*l)+(r3-r2)/(k2*2*pi*rm2*l));
//Ans varies slightly due to approximation in book.
end Ex2_3;
