model Ex2_31
import Modelica.Constants.*;
parameter Real hi(unit = "W/sq m.K")=10"inside heat transfer coefficient ";
parameter Real r1(unit = "m")=0.09"Inner radius of pipe";
parameter Real r2(unit = "m")=0.12"Outer radius of pipe";
parameter Real t(unit = "m")=0.05"thickness of insulation ";
parameter Real k1(unit = "W/m.K")=40"K for pipe material";
parameter Real k2(unit = "W/m.K")=0.05"K for insulation layer";
parameter Real T1(unit = "K")=473"Inside Temperature";
parameter Real T2(unit = "K")=373"Outside Temperature";
Real h0(unit = "W/sq.m.K")"Outside heat transfer coefficient ";
Real Q_by_L(unit = "W")" Heat loss per unit length";
Real r3(unit="m")"radius of outer surface of insulation";
Real Q_by_L1(unit = "W")" Heat loss per unit length";
Real Red(unit = "W/m")"Reduciton in heat loss in [W/m]";
Real percent_red(unit="%")"% Reduction in heat loss";
equation
h0=hi;   
Q_by_L=2*pi*(T1-T2)/(1/(r1*hi)+log(r2/r1)/k1+1/(r2*h0));    
//After addition of insulation:
r3=r2+t;    
Q_by_L1=2*pi*(T1-T2)/(1/(r1*hi)+log(r2/r2)/k1+log(r3/r2)/k2+1/(r3*h0));   
Red=Q_by_L-Q_by_L1;    
percent_red=(Red/Q_by_L)*100;    
end Ex2_31;
