model Ex2_37
import Modelica.Constants.*;
parameter Real k_steel(unit = "W/m.K")=35"K for steel";
parameter Real Cp_steel(unit="J/(kg*K)")=0.46*1000"Cp for steel";
parameter Real h(unit = "W/sq m.K")=10"Convection heat transfer coefficient";
parameter Real rho_steel(unit = "kg/cubic m")=7800"Density";
parameter Real dia(unit="m")=50/1000"Dia. of steel ball";
parameter Real T(unit = "K")=423"required temperarture";
parameter Real T0(unit = "K")=723"Steel ball temperature";
parameter Real T_inf(unit = "K")=373"Atmospheric temperature";
Real R(unit="m")"Radius";
Real A(unit="sq.m")"Area";
Real V(unit="m^3")"Volume";
Real Nbi"Biot Number";
Real t(unit="h")"Time";
equation
R=dia/2;      
A=4*22/7*R^2;  
V=A*R/3;     
Nbi=h*(V/A)/k_steel;
//As Nbi<0.10,internal temp gradient is negligible
t=(-rho_steel*Cp_steel*R*log((T-T_inf)/(T0-T_inf))/(3*h))/3600;   
end Ex2_37;
