model Ex2_43
import Modelica.Math.*;
import Modelica.Constants.*;
parameter Real rho(unit = "kg/cubic m")=8600"Density";
parameter Real Cp(unit="J/(kg*K")=0.42*1000"Cp for thermocouple";
parameter Real dia(unit = "m")=0.71/1000"Diameter of thermocouple ";
parameter Real h(unit = "W/sq m.K")=600"convective coeff ";
//Let length =L=1
parameter Real L(unit = "m")=1"length";
Real R(unit = "m")"radius";
Real A(unit="sq.m")"Area";
Real V(unit = "cubic m")"Volume ";
Real tao(unit = "seconds")"Time constant";
Real t(unit = "seconds")"Time to achieve the desired temperature";
Real ratio"Ratio of thermocouple difference to initial temperature difference";
equation
R=dia/2;    
A=2*pi*R*L;
V=pi*(R^2)*L;
tao=(rho*Cp*V)/(h*A);
t=tao;
ratio=exp(-t/tao); 
//Ans is wrong in book.   
end Ex2_43;
