model Ex2_51
parameter Real k(unit = "W/(m.K)")=75"Thermal conductivity";
parameter Real T_water(unit = "K")=363"Temperature of water";
parameter Real T_air(unit = "K")=303"Temperature of water";
parameter Real h1(unit = "W/(sq m.K)")=150" convective coeff for water";
parameter Real h2(unit = "W/(sq m.K)")=15"convective coeff for air ";
parameter Real W(unit = "m")=0.5"Width of wall";
parameter Real Lb(unit = "m")=0.5"Length of wall";
parameter Real L(unit = "m")=0.025"Length";
parameter Real t(unit = "m")=1/1000"Thickness ";
parameter Real pitch(unit = "m")=10/1000"Pitch";
Real A1(unit = "sq m")"Base Area ";
Real dT(unit="K")"delta T";
Real N"No of fins";
Real Ab(unit = "sq m")"Bare Area";
Real Af(unit = "sq m")"Surface area of fins";
Real A2(unit = "sq m")"Area";
Real Q(unit = "W")"Heat Transfer";
Real P(unit = "m") "Perimeter";
Real m "Constant";
Real nfw"Efficiency";
Real Aew(unit = "sq m")"Effective area on the water side";
Real Q2(unit = "W")"Heat Transfer";
Real m2"Constant";
Real nf_air"Efficiency";
Real Aea(unit="sq m")"Effective area on the air side";
Real Q3(unit = "W")"Heat Transfer";
Real Q4(unit = "W")"Heat Transfer";
Real A(unit="sq.m")"Total Cross Sectional area of fins";
equation
dT=T_water-T_air;   
A1=Lb*W;   
N=W/pitch;    
A=N*W*t;    
Ab=A1-A;   
Af=2*W*L;    
//CASE 1: HEAT TRANSFER WITHOUT FINS
A2=A1;     
Q=dT/(1/(h1*A1)+1/(h2*A2));   
//CASE 2: Fins on the water side
P=2*(t+W);
m=sqrt(h1*P/(k*A));
nfw=tanh(m*L)/(m*L);   
Aew=Ab+nfw*Af*N;    
Q2=dT/(1/(h1*Aew)+1/(h2*A2));        
//CASE 3: FINS ON THE AIR SIDE
m2=sqrt(h2*P/(k*A));
nf_air=tanh(m2*L)/(m2*L);    
Aea=Ab+nf_air*Af*N;    
Q3=dT/(1/(h1*A2)+1/(h2*Aea));      
//BOTH SIDE:
Q4=dT/(1/(h1*Aew)+1/(h2*Aea));       
//h2 value considered wrong in book.Hence value of Q differs.   
end Ex2_51;
