model Ex3_13
import Modelica.Constants.*;
parameter Real v(unit="sq m./s")=15.69*10^(-6)"Kinematic viscocity";   
parameter Real k(unit="W/m.K")=0.02624"Thermal conductivity";   
parameter Real Npr=0.708"Prandtl number"; 
parameter Real mu(unit="kg/m.s")=2.075*10^(-5)"Viscocity";    
parameter Real u_inf(unit="m/s")=4"free stream elocity";    
parameter Real mu_inf(unit="kg/m.s")=1.8462*10^(-5)"Viscocity";   
parameter Real Tw(unit="K")=350"Temperature of sphere";    
parameter Real T_inf(unit="K")=300"Temperature";    
parameter Real D(unit="m")=0.012"Diameter";   
Real r(unit="m")"Radius of sphere";
Real Nre"Reynold's no";
Real Nnu"Nusselt no";
Real h(unit="W/(sq.m.K)")"Average value of Convective heat transfer co-efficient";
Real A(unit="sq m")"Area of sphere";
Real Q(unit="W")"Rate of heat flow";
equation
r=D/2;    
Nre=u_inf*D/v;    
Nnu=2+(0.4*Nre^(1.0/2.0)+0.06*Nre^(2.0/3.0))*Npr^(0.4)*(mu_inf/mu)^(1.0/4.0);
h=Nnu*k/D;    
A=4*pi*r^2;    
Q=h*A*(Tw-T_inf);
end Ex3_13;
