model Ex3_19
parameter Real rho(unit="kg/m^3")=984.1"Density of water";    
parameter Real Cp(unit="J/kg.K")=4187"Specific heat";    
parameter Real mu(unit = "Pa.s")=485*10^(-6)"Viscosity at 331 K";
parameter Real k(unit = "W/(m.K)")=0.657"Thermal conductivity";
parameter Real mu_w(unit = "Pa.s")=920*10^(-6)"Viscosity at 297 K ";
parameter Real D(unit = "m")=16/1000"Diameter";
parameter Real u(unit = "m/s")=3"Velocity";
Real Nre"Reynold number";
Real Npr"Prandtl number";
Real Nnu"Nusselt number";
Real h(unit = "W/sq m.K")"Heat transfer coefficient";
Real Nnu1"Nusselt number";
Real h1(unit = "W/sq m.K")"Heat transfer coefficient";
equation
Nre=D*u*rho/mu;    
Npr=Cp*mu/k;    
//Dittus-Boelter equation (i)
Nnu=0.023*(Nre^0.8)*(Npr^0.3);    
h=k*Nnu/D;    
//sieder-tate equation (ii)
Nnu1=0.023*(Nre^0.8)*(Npr^(1.0/3.0))*((mu/mu_w)^0.14);   
h1=k*Nnu1/D;   
//Calculation mistake in book in part 2
end Ex3_19;
