model Ex3_20
parameter Real m_dot(unit = "kg/h")=2250"Mass flow rate ";
parameter Real Cp(unit = "kJ/(kg.K)")=3.35"Specific heat ";
parameter Real dT(unit = "K")=316-288.5"Temperature drop for oil";
parameter Real Di(unit = "m")=0.04"Inside diameter ";
parameter Real Do(unit = "m")=0.048"Outside diamter ";
parameter Real hi(unit = "W/sq m.K")=4070"heat transfer co-efficeint for steam ";
parameter Real ho(unit = "W/sq m.K")=18.26"heat transfer co-efficeint For oil";
parameter Real Rdo(unit = "sq m.K/W")=0.123"fouling factor for fuel oil";
parameter Real Rdi(unit = "sq m.K/W")=0.215"fouling factor for oily steam";
parameter Real dT1(unit = "K")=373-288.5"Temperature Diffrence";
parameter Real dT2(unit = "K")=373-316"Temperature Diffrence";
Real Q(unit = "J/s")"Rate of heat transfer in ";
Real Uo(unit = "W/m^2.K")"Overall coefficient of heat transfer";
Real dTm(unit = "K")"log mean temperature difference";
Real Ao(unit = "m^2")"Heat transfer area ";
equation
Q=Cp*m_dot*dT*1000/3600;
Uo=1/(1/ho+Do/(hi*Di)+Rdo+Rdi*(Do/Di));   
dTm=(dT1-dT2)/log(dT1/dT2);    //[K]
Ao=Q/(Uo*dTm);  
//Ans in book varies slightly due to approximation.
end Ex3_20;
