model Ex3_21
import Modelica.Constants.*;
parameter Real k_tube(unit = "W/m.K")=111.65"Thermal conductivity of tube";
parameter Real W(unit = "kg/h")=4500"Weight of steam condensed";
parameter Real rho(unit = "kg/sq m")=995.7"Density";
parameter Real Cp(unit = "kJ/(kg.K)")=4.174"Specific heat capacity";
parameter Real k(unit = "W/(m.K)")=0.617"Thermal conductivity of water ";
parameter Real v(unit = "sq m/s")=0.659*10^(-6)"Kinematic viscosity ";
parameter Real m_dot(unit = "kg/h")=1720"mass flow rate";
parameter Real T1(unit = "K")=293"Initial temperature";
parameter Real T2(unit = "K")=318"Final temperature ";
parameter Real Di(unit = "m")=0.0225"Od of tube";
parameter Real u(unit = "m/s")=1.2"water velocity";
parameter Real Do(unit = "m")=0.025"OD of tube";
parameter Real ho(unit = "W/sq m.K")=4650"heat transfer co-efficeint";
parameter Real k1(unit = "W/m.K")=111.65"Thermal conductivity ";
parameter Real T_steam(unit = "K")=373"Temperature of condensing steam ";
parameter Real L(unit = "m")=4"length of tube";
Real dT(unit = "K")"Temperature difference";
Real Q(unit = "J/s")"Heat transfer rate ";
Real Nre"Reynolds number";
Real mu(unit = "kg/(m.s)")"Viscocity";
Real Npr"Prandlt number";
Real Nnu"Nusselt number";
Real hi(unit = "W/(sq m.K)")"Heat transfer coefficient ";
Real Dw(unit = "m")"Log mean diameter ";
Real xw(unit = "m")"Thickness";
Real Uo(unit="W/m^2.K")"Overall heat transfer coefficient";
Real dT1(unit = "K")"Temperature gradient";
Real dT2(unit = "K")"Temperature gradient";
Real dTm(unit = "K")"Log mean temperature diiference";
Real Ao(unit = "m^2")"Area ";
Real n"number of tubes";
equation
dT=T2-T1;    
Q=m_dot*Cp*dT*1000/3600;    
Nre=Di*u/v;   
mu=v*rho;    
Npr=Cp*10^3*mu/k;    
//Dittus-Boelter equation for heating is 
Nnu=0.023*(Nre^0.8)*(Npr^0.4);
hi=k*Nnu/Di;    
Dw=(Do-Di)/log(Do/Di);   
xw=(Do-Di)/2;    
Uo=1/(1/ho+Do/(hi*Di)+xw*Do/(k1*Dw));    
dT1=T_steam-T1+10;   
dT2=T_steam-T2+10;   
dTm=(dT1-dT2)/log(dT1/dT2);    
Ao=Q/(Uo*dTm);
n=Ao/(pi*Do*L);
//Ans in book is rounded to 1
end Ex3_21;
