model Ex3_22
import Modelica.Constants.*;
parameter Real m_dot(unit = "kg/h")=25000"massflow rate of water ";
parameter Real rho(unit = "kg/m^3")=992.2"Density";
parameter Real k(unit = "W/m.K")=0.634"Thermal conductivity of water ";
parameter Real Npr=4.31"Prandtl numberl";
parameter Real Di(unit = "m")=0.05"Id of tube";
parameter Real dT(unit = "K")=10"Temperature gradient"; //as the wall is at a temperature of 10 K above the bulk temperature"
parameter Real v(unit = "m^2/s")=0.659*10^(-6)"Kinematic viscosity ";
Real vfr(unit = "m^3/h")"Vlometric flowrate";
Real u(unit = "m/s")"Velocity of water ";
Real Nre"Reynolds number";
Real Nnu"Nusselt number";
Real hi(unit = "W/sq m.K")"Heat transfer coefficiet" ;
Real q_by_l(unit = "kW/m")"Heat transfer per unit length";
equation
vfr=m_dot/rho;    
u=(vfr/3600)/(pi*(Di/2)^2);  
Nre=Di*u/(v);    
Nnu=0.023*(Nre^0.8)*(Npr^0.4);    
hi=Nnu*k/Di;    
q_by_l=hi*pi*Di*dT*10^(-3);   
end Ex3_22;
