model Ex3_26
import Modelica.Constants.*;
parameter Real k(unit = "W/m.K")=0.14" Thermal conductivity for oil";
parameter Real Cp(unit = "J/kg.K")=2.1*10^3"Specific heat capacity  for oil ";
parameter Real mu(unit = "N.s/sq m")=154*10^(-3)"Viscosity";
parameter Real mu_w(unit = "N.s/sq m")=87*10^(-3)"Viscosity of water ";
parameter Real L(unit = "m")=1.5"Length";
parameter Real m_dot(unit = "kg/s")=0.5"Mass flow rate of oil";
parameter Real Di(unit = "m")=0.019"Diameter of tube ";
parameter Real mean_T(unit = "K")=319"Mean temperature of oil ";
Real A(unit = "sq m")"Area";
Real G(unit = "kg/sq m.s")"Mass velocity ";
Real Nre"Reynold number";
Real hi(unit = "W/sq m.K")"Heat transfer coeff. ";
equation
A=pi*(Di/2)^2;   
G=m_dot/A;   
Nre=Di*G/mu;
//The sieder tate equation is 
hi=(k*(2.0*((m_dot*Cp)/(k*L))^(1.0/3.0)*(mu/mu_w)^(0.14)))/Di;   
//Calculation mistake in book
end Ex3_26;
