model Ex3_30
parameter Real k(unit = "W/m.K")=0.02685"Thermal conductivity";
parameter Real v(unit="kg/(m.s)")=16.5*10^(-6)"Viscocity";
parameter Real Npr=0.7"Prandtl number";
parameter Real Beta(unit="1/K")=3.25*10^(-3)"Volume expansion coefficient";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to gravity";
parameter Real Tw(unit = "K")=333"Temperature of solid surface";
parameter Real T_inf(unit = "K")=283"Average Temperature";
parameter Real L(unit = "m")=4"Length/height  of plate ";
parameter Real W(unit = "m")=7"width ";
Real dT(unit = "K")"Temperature gradient";
Real Ngr"Grashof number";
Real const;
Real Nnu"Nusselt number";
Real h(unit = "W/sq m.K")"Average heat transfer coefficient";
Real A(unit = "sq m")"Area of heat transfer" ;
Real Q(unit ="W")"Heat Transfer";
equation
dT=Tw-T_inf; 
Ngr=(g*Beta*dT*(L^3))/(v^2);  
//Let const=Ngr*Npr
const=Ngr*Npr;
//Sice it is >10^9
Nnu=0.10*(const^(1.0/3.0));   
h=Nnu*k/L;   
A=L*W;   
Q=h*A*dT;    
//Ans in book varies due to approximation
end Ex3_30;
