model Ex3_31
import Modelica.Constants.*;
parameter Real v(unit="m^2/s")=18.97*10^(-6)"Viscocity ";
parameter Real k(unit = "W/m.K")=28.96*10^(-3)"Thermal conductivity";
parameter Real Npr=0.696"Prandtl number";
parameter Real D(unit = "m")=100/1000"Outer diameter ";
parameter Real Tf(unit = "K")=333"Film temperature ";
parameter Real Tw(unit = "K")=373"Pipe surface temperature";
parameter Real T_inf(unit = "K")=293"Temperature of air";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to gravity";
parameter Real L(unit = "m")=3"Length of pipe ";
Real dT(unit = "K")"Temperature gradient";
Real Beta(unit = "K^-1")"Volume expansion coefficient";
Real Ngr"Grashof number";
Real Nra"rayleigh number";
Real Nnu"Nusselt number";
Real h(unit = "W/sq m.K")"Average heat transfer coefficient";
Real Q_by_l(unit = "W/m")"Heat loss per metre length ";
equation
dT=Tw-T_inf; 
Beta=1/Tf;   
Ngr=(g*Beta*dT*(L^3))/(v^2); 
Nra=Ngr*Npr;
Nnu=0.10*(Ngr*Npr)^(1.0/3.0);    
h=Nnu*k/L;  
Q_by_l=h*pi*D*dT;   
end Ex3_31;
