package Ex3_37
  model Ex3_37_a
  import Modelica.Constants.*;
  parameter Real k(unit = "W/(m.K)")= 0.03"Thermal conductivity";
  parameter Real v(unit = "m^2/s")= 2.076 * 10 ^ (-6)"Kinematic viscocity";
  parameter Real Npr = 0.697 "Prandtl number";
  parameter Real D(unit = "Diameter in m")= 25 / 100"[Diameter ";
  parameter Real Tf(unit = "K")= 343"Film temperature ";
  parameter Real T1(unit = "K")= 293"Temperature of air";
  parameter Real T2(unit = "K")= 393"Temperature of disc";
  parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to  gravity";
  Real A(unit = "m^2")"Area ";
  Real P(unit = "m")"Perimeter ";
  Real L(unit = "m")"Characteristic dimension/length";
  Real Beta(unit = "K^-1")"Volume expansion coefficient";
  Real dT(unit = "K")"Temperature gradient";
  Real Nra"rayleigh number";
  Real Nnu "Nusselt number";
  Real Ngr"Grashof number";
  Real h(unit = "W/sq m.K") "Average heat transfer coefficient ";
  Real Q(unit = "W")"Heat transfer";
  equation
  A = pi * (D / 2) ^ 2;
  P = pi * D;
  //Case (i) HOT SURFACE FACING UPWARD
  L = A / P;
  Beta = 1 / Tf;//[K^-1]
  dT = T2 - T1;//[K]
  Ngr = g * Beta * dT * L ^ 3 / v ^ 2;
  Nra = Ngr * Npr;
  Nnu = 0.15 * Nra ^ (1.0 / 3.0);
  h = Nnu * k / L;
  Q = h * A * dT;
  end Ex3_37_a;



  model Ex3_37_b
  import Modelica.Constants.*;
  parameter Real k(unit = "W/(m.K)")= 0.03"Thermal conductivity";
  parameter Real D(unit = "Diameter in m")= 25 / 100"[Diameter ";
  parameter Real T1(unit = "K")= 293"Temperature of air";
  parameter Real T2(unit = "K")= 393"Temperature of disc";
  parameter Real Nra=1.13*10^8"rayleigh number"; 
  Real A(unit = "m^2")"Area ";
  Real P(unit = "m")"Perimeter ";
  Real L(unit = "m")"Characteristic dimension/length";
  Real dT(unit = "K")"Temperature gradient";
  Real Nnu "Nusselt number";
  Real h(unit = "W/sq m.K") "Average heat transfer coefficient ";
  Real Q(unit = "W")"Heat transfer";
  equation
  A = pi * (D / 2) ^ 2;
  P = pi * D;
  //Case (i) HOT SURFACE FACING UPWARD
  L = A / P;
  dT = T2 - T1;
  Nnu=0.27*(Nra^(1/4));    
  h=Nnu*k/L;   
  Q=h*A*dT;    
  end Ex3_37_b;




  model Ex3_37_c
  import Modelica.Constants.*;
  parameter Real k(unit = "W/(m.K)")= 0.03"Thermal conductivity";
  parameter Real v(unit = "m^2/s")= 2.076 * 10 ^ (-6)"Kinematic viscocity";
  parameter Real Npr = 0.697 "Prandtl number";
  parameter Real D(unit = "Diameter in m")= 25 / 100"[Diameter ";
  parameter Real Tf(unit = "K")= 343"Film temperature ";
  parameter Real T1(unit = "K")= 293"Temperature of air";
  parameter Real T2(unit = "K")= 393"Temperature of disc";
  parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to  gravity";
  Real A(unit = "m^2")"Area ";
  Real P(unit = "m")"Perimeter ";
  Real L(unit = "m")"Characteristic dimension/length";
  Real Beta(unit = "K^-1")"Volume expansion coefficient";
  Real dT(unit = "K")"Temperature gradient";
  Real Nra"rayleigh number";
  Real Nnu "Nusselt number";
  Real Ngr"Grashof number";
  Real h(unit = "W/sq m.K") "Average heat transfer coefficient ";
  Real Q(unit = "W")"Heat transfer";
  equation
  A = pi * (D / 2) ^ 2;
  P = pi * D;
  L = D;
  Beta = 1 / Tf;
  dT = T2 - T1;
  Ngr = g * Beta * dT * L ^ 3 / v ^ 2;
  Nra = Ngr * Npr;
  Nnu = 0.10 * Nra ^ (1.0 / 3.0);
  h = Nnu * k / L;
  Q = h * A * dT;
  //Value of g is considered wrong during calculation in bbok.
  end Ex3_37_c;



end Ex3_37;
