model Ex3_43
import Modelica.Constants.*;
parameter Real lambda(unit = "J/kg")=2257*1000"Latent heat-enthaply of vaporisation";
parameter Real rho_l(unit = "kg/m^3")=957.9"Density of saturated liquid";
parameter Real rho_v(unit = "kg/m^3")=0.5955"Density of saturated vapour";
parameter Real sigma(unit = "N/m")=5.89*10^(-2)"Surface tension of liquid-vapor interface";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
Real Q_by_A_max(unit="MW/sq.m")"peak heat flux";
equation
//Peak heat flux is given by
Q_by_A_max=((pi/24)*(lambda*rho_v^0.5*(sigma*g*(rho_l-rho_v))^(1/4)))/(10^6) ;  
end Ex3_43;
