model Ex3_44
import Modelica.Constants.*;
parameter Real rho_l(unit = "kg/m^3")=957.9"Density of saturated liquid";
parameter Real lambda(unit = "J/kg")=2257*10^3"Latent heat-enthaply of vaporisation";
parameter Real rho_v(unit = "kg/m^3")=31.54"Density of saturated vapour";
parameter Real Cpv(unit = "J/kg.K")=4.64*10^3"Specific Heat capacity";
parameter Real kv(unit = "W/(m.K)")=58.3*10^(-3)"thermal conductivity of vapor";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
parameter Real mu_v(unit = "kg/(m.s)")=18.6*10^(-6)"viscocity";
parameter Real e=1.0"Emissivity";
parameter Real sigma(unit="m")=5.67*10^(-8)"Stefan Boltzman constant";
parameter Real Ts(unit = "K")=373"Saturation temperature";
parameter Real Tw(unit = "K")=628"Surface temperature";
parameter Real D(unit = "m")=1.6*10^(-3)"Diamter";
Real dT(unit = "K")"Temperature gradient";
Real T(unit = "K")"Temperature";
Real hc(unit = "W/sq m.K")"Convective heat transfer coeff  ";
Real hr(unit = "W/sq m.K")"Radiation heat transfer coeff ";
Real h(unit="W/(sq m.K)")"Total heat transfer coefficient";
Real Q_by_l(unit = "kW/m")"Heat dissipation rate per unit length  ";
equation
dT=Tw-Ts;    
T=(Tw+Ts)/2;
hc=0.62*((kv^3)*rho_v*(rho_l-rho_v)*g*(lambda+0.40*Cpv*dT)/(D*mu_v*dT))^(1.0/4.0); 
hr=e*sigma*(Tw^4-Ts^4)/(Tw-Ts); 
h=hc+(3/4)*hr;   
Q_by_l=h*pi*D*dT/1000;   
end Ex3_44;
