model Ex3_53
parameter Real rho(unit = "kg/m^3")=975"Density";
parameter Real k(unit = "W/(m.K)")=0.671"thermal conductivity";
parameter Real mu(unit = "N.s/m^2")=3.8*10^(-4)"viscocity";
parameter Real dT(unit = "K")=10"Temperature gradient";
parameter Real lambda(unit = "J/kg")=2300*10^3" Latent heat of condensation ";
parameter Real L(unit = "m")=1"Length";
parameter Real g(unit = "m/s^2")=9.81"Acceleration due to  gravity";
parameter Real x(unit = "m")=0.5"";
Real h(unit = "W/sq m.K")"Heat transfer coefficient";
Real h1(unit = "W/sq m.K")"Local Heat transfer coefficient";
Real delta(unit = "m")"Film thickness";
equation
h=0.943*((rho^2*lambda*g*k^3)/(mu*L*dT))^(1/4); 
//Local heat transfer coefficient
h1=((rho^2*lambda*g*k^3)/(4*mu*dT*x))^(1/4); 
delta=(((4*mu*dT*k*x)/(lambda*rho^2*g))^(1/4))*10^3;
// Ans varies due to approximation.
end Ex3_53;
