model Ex4_18
parameter Real sigma(unit = "W/(sq m.K^4)")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real T1(unit = "K")=813"Temperature of tube A";
parameter Real T2(unit = "K")=473"Temperature of tube B";
parameter Real e1=0.87"Emissivity of tube A";
parameter Real e2=0.26"Emissivity of tube B";
parameter Real D1(unit = "m")=0.25 "Diamter of tube A";
parameter Real D2(unit = "m")=0.3"Diamter of tube B";
Real Q_by_a1(unit = "W/ sq.m")"Heat transfer";
equation
Q_by_a1=sigma*(T1^4-T2^4)/(1/e1+(D1/D2)*(1/e2-1));  
end Ex4_18;
