model Ex4_23
parameter Real sigma(unit = "W/(sq m.K^4)")=5.67*10^(-8)"stefan Boltzman Constant";
parameter Real e1=0.7"Emissivity ";
parameter Real e2=0.7"Emissivity ";
parameter Real T1(unit = "K")=866.5"Temperature of plane 1";
parameter Real T2(unit = "K")=588.8"Temperature of plane 2";
parameter Real es1=0.7"Emissivity ";//es1=e1
parameter Real es2=0.7"Emissivity ";//es2=e1
parameter Real n=2"Number of plate";
Real Q_by_A(unit = "W/sq m")"Heat transfer without shield";
Real Q_shield(unit = "W/sq m")"Heat transfer with shield";
Real Q_by_A1(unit = "W/sq m")"Heat transfer with shield";
equation
Q_by_A=sigma*(T1^4-T2^4)/((1/e1)+(1/e2)-1);  
//Q with n shells =1/(n+1)
Q_shield=1/(n+1)*Q_by_A;
Q_by_A1=sigma*(T1^4-T2^4)/((1/e1)+(1/e2)+2*(1/es1+1/es2)-(n+1));  
end Ex4_23;
