model Ex4_24
import Modelica.Constants.*;
//1.WITHOUT SHIELD
parameter Real sigma(unit = "W/(sq m.K^4)")=5.67*10^(-8)"stefan Boltzman Constant";      
parameter Real e1=0.12"surface emissivity on inner tube";
parameter Real e2=0.15"surface emissivity on outer tube";
parameter Real T1(unit = "K")=100"Temperature of inner  tube";
parameter Real T2(unit = "K")=300"Temperature of outer  tube";
parameter Real r1(unit = "m")=0.015"inner radius";
parameter Real r2(unit = "m")=0.045"outer radius";
parameter Real L(unit = "m")=1"Length";
parameter Real F13(unit="m")=1"Shape factor";
parameter Real F32(unit="m")=1"Shape factor";
parameter Real e3=0.10"Emissivity of shield";
parameter Real e4=0.05"Emissivity of shield";
parameter Real r3(unit = "m")=0.0225"radius of shield";
Real A1(unit = "sq m")"Area of inner tube";
Real A2(unit = "sq m")"Area of outer tube";
Real A3(unit = "sq m")"Area of shield";
Real R1"Resistance 1";
Real R2"Resistance 2";
Real R3"Resistance 3";
Real R4"Resistance 4";
Real R5"Resistance 5";
Real R6"Resistance 6";
Real Q_by_L(unit = "W/m")"Heat transfer without shield";
Real Qs_by_L(unit = "W/sq m")"Heat transfer with shield";
Real red(unit="%")"percent reduction in heat gain";
Real Qs(unit = "W/sq m")"Heat transfer";
equation
A1=2*pi*r1*L;   //[sq m]
Q_by_L=2*pi*r1*sigma*(T1^4-T2^4)/(1/e1+(r1/r2)*(1/e2-1));   
//-ve sign indicates that the net heat flow is in the radial inward direction
//2.WITH CYLINDRICAL RADIATION SHIELD
Qs_by_L=2*pi*r1*sigma*(T1^4-T2^4)/(1/e1+r1/r2*(1/e2-1)+(r1/r3)*(1/e3+1/e4-1));  
red=(abs(Q_by_L)-abs(Qs_by_L))*100/abs(Q_by_L);  
A3=2*pi*r3;    
A2=2*pi*r2;     
R1=(1-e1)/(e1*A1);
R2=1/(A1*F13);
R3=(1-e3)/(e3*A3);
R4=(1-e4)/(e4*A3);
R5=1/(A3*F32);
R6=(1-e2)/(e2*A2);
Qs=sigma*(T1^4-T2^4)/((1-e1)/(e1*A1)+1/(A1*F13)+(1-e3)/(e3*A3)+(1-e4)/(e4*A3)+1/(A3*F32)+(1-e2)/(e2*A2));        
end Ex4_24;
