package Ex4_9
  model Ex4_9_a
    parameter Real sigma(unit = "W/m^2.K^4") = 5.67 * 10 ^ (-8) "stefan Boltzman Constant";
    parameter Real T1(unit="K")=368"Temperature of hot plane"; 
    parameter Real T2(unit = "K")=293"Temperature of cold plane";
    parameter Real e1 = 0.05 "Emissivity";
    parameter Real e2 = 0.05 "Emissivity";
    parameter Real A1(unit = "sq.m") = 1 "Area";
    parameter Real A2(unit = "sq.m") = 1 "Area";
    Real F12 "Interchange factor";
    Real Q_by_A(unit = "W/sq m") "Heat loss per unit Area of silvered surface ";
  equation
      F12=1/((1/e1)+(1/e2)-1);
    Q_by_A=sigma*F12*(T1^4-T2^4);
  end Ex4_9_a;





  model Ex4_9_b
    parameter Real sigma(unit = "W/m^2.K^4") = 5.67 * 10 ^ (-8) "stefan Boltzman Constant";
    parameter Real T1(unit="K")=368"Temperature of hot plane"; 
    parameter Real T2(unit = "K")=293"Temperature of cold plane";
    parameter Real e1 = 1 "Emissivity";
    parameter Real e2 = 1 "Emissivity";
    parameter Real A1(unit = "sq.m") = 1 "Area";
    parameter Real A2(unit = "sq.m") = 1 "Area";
    Real F12 "Interchange factor";
    Real Q_by_A(unit = "W/sq m") "Heat loss per unit Area of black surface ";
  equation
      F12=1/((1/e1)+(1/e2)-1);
    Q_by_A=sigma*F12*(T1^4-T2^4);
  end Ex4_9_b;


end Ex4_9;
