model Ex5_12
import Modelica.Constants.*;
import Modelia.Maths.*;
parameter Real t1(unit = "K")=290"Inlet temperature of cooling water"; 
parameter Real ho(unit = "W/sq m.K")=2250"Heat transfer coefficient based on inside area ";
parameter Real lambda(unit = "kJ/kg")=400"LAtent heat of benzene"; 
parameter Real mb_dot(unit="t/h")=14.4"Condensation rate of benzene vapour";
parameter Real Cpw(unit = "J/kg.K")=4.187*10^3"Specific heat";
//Shell and tube type of heat exchanger is used as a single pass surface condenser
parameter Real T(unit = "K")=350"Condensing benzene temperature";
parameter Real Di(unit = "m")=0.022"I.D of tube";
parameter Real L(unit = "m")=2.5"Length of each tube";
parameter Real n=120"Number of tubes";
parameter Real u(unit = "ms^-1")=0.75"Velocty of water ";
parameter Real rho(unit = "kg/m^3")=1000"Density of water ";
parameter Real Rd(unit="m^2.K/W")=2.5*10^(-4)"dirt factor";
Real A(unit = "sq.m")"Total area of heat transfer";
Real Ai(unit = "sq.m")"Total area of flow";
Real V(unit = "m3/sec")"Volumetric flow of water ";
Real Q(unit = "W") "Heat duty of condenser";
Real t2(unit = "K")"Outlet temperature of cooling water";
Real dT1(unit = "K")"Temperature gradient ";
Real dT2(unit = "K")"Temperature gradient ";
Real dTlm(unit = "K")"Log mean temperature differnce";
Real U(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real hi(unit = "W/sq m.K")"Heat transfer coefficient";
Real C"constant";
Real U1(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real u1(unit = "m/sec", start = 3)"Water Velocity";
Real mw_dot(unit="kg/s")"Mass flow rate of water ";
Real mw_dot1(unit="kg/s")"Mass flow rate of water ";
Real t21(unit = "K")"Outlet temperature of cooling water";
Real dT21(unit = "K")"Temperature gradient ";
Real dTlm1(unit = "K")"Log mean temperature differnce";
equation
A=pi*Di*L*n;      
Ai=n*(pi/4)*Di^2; 
V=u*Ai;          
mw_dot=V*rho;    
//With no Scale
Q=(mb_dot*1000*lambda)*1000/3600;     
//Heat balance
Q=mw_dot*Cpw*(t2-t1);
dT1=T-t1;   
dT2=T-t2;  
dTlm=(dT1-dT2)/log(dT1/dT2);  
Q=U*A*dTlm; 
//Neglecting resistance,we have:
1/U=1/ho+1/hi;                       
//hi is proportional to u^0.8
C=hi/(u^0.8);      
//With Scale  
//The  answer may slightly vary due to  rounding off values" 
1/U1=(1/4873.4*u1^0.8)+1/ho+Rd;
mw_dot1=rho*u1*Ai;     
//Let t2 be the outlet temperature of water 
Q=mw_dot1*Cpw*(t21-t1); 
dT21=T-(t21);
dTlm1= (dT1- dT21)/log(dT1/dT21);
//Q=U1*A*dTlm1;
Q=((4873.4*u1^0.8)/(1+3.38*u1^0.8))*A*(8.373/(u1*log((60*u1)/(60*u1-8.373))));
end Ex5_12;
