model Ex5_17
import Modelica.Constants.*;
parameter Real mb_dot(unit = "kg/s")=1.25"Mass flow rate of Benzene ";
parameter Real Cpb(unit = "J/kg.K")=1.9*10^3"Heat capacity of For benzene ";
parameter Real Cpw(unit = "J/kg.K")=4.187*10^3"Heat capacity of For water ";
parameter Real T1(unit = "K")=350"Inlet temperature of Benzene";
parameter Real T2(unit = "K")=300"Outlet temperature of Benzene";
parameter Real t1(unit = "K")=290"Inlet temperature of water";
parameter Real t2(unit = "K")=320"outlet temperature of water";
parameter Real hi(unit = "W/sq m.K")=850"water side heat transfer coefficient";
parameter Real ho(unit = "W/sq m.K")=1700"benzene side heat transfer coefficient";
parameter Real Do(unit = "m")=0.025"Outer Dia.";
parameter Real Di(unit = "m")=0.022"Inner Dia.";
parameter Real k(unit = "W/m.K")=45"Thermal Conductivity";
parameter Real L(unit = "m")=1"Length ";
Real Q(unit = "W")"Rate of Heat transfer";
Real dT1(unit="K")"Temperature gradient";
Real dT2(unit="K")"Temperature gradient";
Real dTlm(unit="K")"Log mean temperature differnece";
Real mw_dot(unit = "kg/s")"Minimum flow rate of water ";
Real x(unit = "m")"Thickness ";
Real hio(unit = "W/sq m.K")"heat transfer coefficient";
Real Dw(unit = "m")"log mean Dimaeter";
Real Uo(unit = "W/sq m.K")"Overall heat transfer co-efficoent";
Real Ao(unit = "sq m")"Area";
Real area(unit="sq m")"Outside surface area of tube per length ";
Real TL(unit = "m")"Total length of tubing required";
equation
Q=mb_dot*Cpb*(T1-T2);    
dT1=T1-t2;               
dT2=T2-t1;               
dTlm=(dT1-dT2)/log(dT1/dT2); 
mw_dot=Q/(Cpw*(t2-t1));         
x=(Do-Di)/2;                   
hio=hi*(Di/Do);              
Dw=(Do-Di)/log(Do/Di);       
Uo=1/((1/ho)+(1/hio)+(x/k)*(Do/Dw)); 
Ao=Q/(Uo*dTlm);                  
area=pi*Do*L;                   
TL=Ao/area;                      
end Ex5_17;
