model Ex5_2
import Modelica.Constants.*;
parameter Real ma_dot(unit = "kg/h")=300*1000/24"Mass flow rate of acid ";
parameter Real mw_dot(unit = "kg/h")=500*1000/24"Mass flow rate of water ";
parameter Real Cp1(unit = "kJ/kg.K")=1.465"Specific heat capacity";
parameter Real T1(unit = "K")=333"Inelt temperature of Acid";
parameter Real T2(unit = "K")=313"Outlet temperature of Acid";
parameter Real Cp2(unit = "kJ/kg.K")=4.187"Specific heat capacity";
parameter Real t1(unit = "K")=288"Initial temperature of water";
//Inner pipe
parameter Real Di(unit = "m")=0.075"inner diameter";
parameter Real mua(unit = "kg/m.s")=0.0112"viscocity";
parameter Real ka(unit = "W/m.K")=0.302"Thermal conductivity";
parameter Real Do(unit = "m")=0.1"OD";
parameter Real D1(unit = "m")=0.1"OD of inner pipe";
parameter Real D2(unit = "m")=0.125"inner dia of outer  pipe";
parameter Real muw(unit = "kg/m.s")=0.0011"viscocity";
parameter Real kwa(unit = "W/m.K")=0.669"Thermal conductivity for water";
parameter Real kw(unit = "W/m.K")=46.52"thermal conductivity of wall ";
Real Q(unit = "W")"Rate of heat transfer";
Real t2(unit = "K")"Outer temperature of water";
Real dT1(unit = "K")"Temperature gradient ";
Real dT2(unit = "K")"Temperature gradient ";
Real dTlm(unit = "K")"Log mean temperature difference ";
Real Ai(unit = "sq m")"Area";
Real G(unit = "kg/sq m.s")"Mass velocity";
Real Nrea"Reynolds number";
Real Npra"Prandtl number";
Real hi(unit= "W/sq m.K")"inside Convective heat transfer coefficient";
Real hio(unit= "W/sq m.K")"Convective heat transfer coefficient referred to OD";
Real De(unit = "m")"shell equivalent diameter";
Real Aa(unit = "sq m")"Area";
Real Ga(unit = "kg/sq m.s")"Mass velocity";
Real Nrew"Reynolds number";
Real Nprw"Prandtl number";
Real ho(unit = "W/sq m.K")"Convective heat transfer coefficient";
Real xw(unit = "m")"Wall thickness";
Real Dw(unit = "m")"Log mean diameter";
Real Uc(unit = "W/sq m.K")"Overall clean heat transfer coefficient";
Real Ud(unit = "W/sq m.K")"Overall dirt heat transfer coefficient";
Real A(unit = "sq m")"Area";
Real L(unit = "m")"Length";
equation
Q=ma_dot*Cp1*(T1-T2);              
t2=(Q/(mw_dot*Cp2))+t1;      
dT1=T1-t2;                  
dT2=T2-t1;                   
dTlm=(dT1-dT2)/log(dT1/dT2);
Ai=(pi/4)*Di^2;            
G=(ma_dot/Ai)/3600;                   
Nrea=Di*G/mua;                 
Npra=Cp1*10^3*mua/ka;                
hi=(ka/Di)*0.023*(Nrea^0.8)*(Npra^0.3);     
hio=hi*Di/Do;                
De=(D2^2-D1^2)/D1;           
Aa=(pi/4)*(D2^2-D1^2);      
Ga=(mw_dot/Aa)/3600;                  
Nrew=De*Ga/muw;                
Nprw=Cp2*10^3*muw/kwa;                 
ho=(kwa/De)*0.023*(Nrew^0.8)*(Nprw^0.4);   
xw=(Do-Di)/2;                     
Dw=(Do-Di)/log(Do/Di);          
Uc=1/(1/ho+1/hio+xw*Do/(kw*Dw));  
Ud=Uc;                       
A=(Q*1000/3600)/(Ud*dTlm);             
L=A/(pi*Do);                
end Ex5_2;
