model Ex5_20
parameter Real Cpo(unit = "kJ/kg.K")=1.9"Heat capacity for oil";
parameter Real Cps(unit = "kJ/kg.K")=1.86"Heat capacity for steam ";
parameter Real ms_dot(unit = "kg/s")=5.2"Mass flow rate ";
parameter Real T1(unit = "K")=403"Inlet temperature of steam";
parameter Real T2(unit = "K")=383"outlet temperature of steam";
parameter Real t1(unit = "K")=288"Inlet temperature of oil";
parameter Real t2(unit = "K")=358"Outlet temperature of oil";
parameter Real U(unit = "W//sq m.K")=275"Overall heat transfer coeffcient";
parameter Real Ft=0.97"LMTD correction factor";
Real Q(unit = "W")"Rate of Heat transfer";
Real dT1(unit="K")"Temperature gradient";
Real dT2(unit="K")"Temperature gradient";
Real dTlm(unit="K")"Log mean temperature differnece";
Real A(unit="sq.m")"Area";
equation
Q=ms_dot*Cps*(T1-T2)*1000;                    
dT2=T1-t2;                   
dT1=T2-t1;                   
dTlm=(dT1-dT2)/log(dT1/dT2);     
A=Q/(U*Ft*dTlm);                 
end Ex5_20;
