model Ex5_24
import Modelica.Constants.*;
parameter Real ho(unit = "W/sq m.K")=200"Convective heat transfer coeficient on oil side";
parameter Real hi(unit = "W/sq m.K")=1500"Convective heat transfer coeficient on water side";
parameter Real Cpw(unit = "kJ/(kg.K)")=4.2"Sp heat of Water ";
parameter Real Cpo(unit = "kJ/(kg.K)")=2.1"Sp heat of Oil ";
parameter Real E=0.8"Effectiveness";
parameter Real k(unit = "W/m.K")=46"Thermal conductivity";
parameter Real m_dot(unit = "kg/s")=0.167"Mass flowrate of water";
parameter Real mCp_small(unit = "W/K")=710.4"Heat capacity rate";
parameter Real C=1"capcity ratio";
parameter Real id(unit = "mm")=20"Internal diameter ";
parameter Real od(unit = "mm")=25"External diameter ";
parameter Real Do(unit = "m")=0.025"External dia ";
parameter Real L(unit = "m")=2.5"Length of tube ";
Real mCp_oil(unit = "W/K")"Sp heat of oil [W/K]";
Real mCp_water(unit = "W/K")"Heat capacity rate For water ";
Real hio(unit = "W/sq m.K")"Convective heat transfer coeficient";
Real Dw(unit = "m")"Log mean diameter";
Real x(unit = "m")"Wall thickness";
Real Uo(unit = "W/sq m K")"Overall heat transfer coefficient";
Real A(unit = "sq m")"Heat transfer area ";
Real ntu" number of transfer units";
Real n"No of tubes";
equation
mCp_oil=2*m_dot*Cpo*1000;      //For oil [W/K]
//mCp_oil is wrongly calculated as 710.4
mCp_water=m_dot*Cpw*1000;      //For water [W/K]
//mCp_oil is wrongly calculated as 710.4
//NOTE:The above two values are wrongly calculated in book as 710.4
E=ntu/(1+ntu);
hio=hi*id/od;        
Dw=((od-id)/log(od/id))/1000;            
x=((od-id)/2)/1000;            
Uo=1/(1/ho+1/hio+(x/k)*(Dw/Do));     
A=ntu*mCp_small/Uo;  
n=A/(pi*Do*L);
//Ans varies due to approximation      
end Ex5_24;
