package Ex5_25
  model Ex5_25_a
    parameter Real T1(unit = "K") = 633 "Inlet Temperature of oil";
    parameter Real t2(unit = "K") = 303 "outlet Temperature of  coolant";
    parameter Real T2(unit = "K") = 573 "outlet Temperature of oil";
    parameter Real t1(unit = "K") = 400 "Inlet Temperature of coolant";
    parameter Real mh_dot(unit = "kg/s") = 1.2 "Mass flowrate";
    parameter Real U(unit = "W/sqm.K") = 500 "Overall heat transfer coefficient in ";
    parameter Real Cp(unit = "J/kg.K") = 2083 "Sp.heat of oil";
    Real Q(unit = "W") "Rate of heat transfer";
    Real dT1(unit = "K") "Temperature gradient ";
    Real dT2(unit = "K") "Temperature gradient ";
    Real dTlm(unit = "K") "Log mean temperature differnce";
    Real A(unit = "sq m") "Area";
  equation
    Q = mh_dot * Cp * (T1 - T2);
//(i)Parallel flow
    dT1 = T1 - t2;
    dT2 = T2 - t1;
    dTlm = (dT1 - dT2) / log(dT1 / dT2);
    A = Q / (U * dTlm);
  end Ex5_25_a;



  model Ex5_25_b
    parameter Real T1(unit = "K") = 633 "Inlet Temperature of oil";
    parameter Real t2(unit = "K") = 303 "outlet Temperature of  coolant";
    parameter Real T2(unit = "K") = 573 "outlet Temperature of oil";
    parameter Real t1(unit = "K") = 400 "Inlet Temperature of coolant";
    parameter Real mh_dot(unit = "kg/s") = 1.2 "Mass flowrate";
    parameter Real U(unit = "W/sqm.K") = 500 "Overall heat transfer coefficient in ";
    parameter Real Cp(unit = "J/kg.K") = 2083 "Sp.heat of oil";
    Real Q(unit = "W") "Rate of heat transfer";
    Real dT1(unit = "K") "Temperature gradient ";
    Real dT2(unit = "K") "Temperature gradient ";
    Real dTlm(unit = "K") "Log mean temperature differnce";
    Real A(unit = "sq m") "Area";
  equation
    Q = mh_dot * Cp * (T1 - T2);
  //(ii)Counter current flow
    dT1 = T1 - t1;
    dT2= T2 - t2;
    dTlm = (dT2 - dT1) / log(dT2/ dT1);
    A = Q / (U * dTlm);
  end Ex5_25_b;


end Ex5_25;
