model Ex5_3
import Modelica.Constants.*;
parameter Real me_dot(unit = "kg/h")=5500"Mass flowrate ";
parameter Real Di(unit = "m")=0.037"I.D of inner pipe";
parameter Real mu(unit = "Pa.s")=3.4*10^(-3)"Viscocity";
parameter Real Cp(unit = "kJ/kg.K")=2.68"Specific heat capacity";
parameter Real k(unit = "W/m.K")=0.248"Thermal conductivity";
parameter Real T2(unit = "K")=358"Inlet temperature of glycol";
parameter Real T1(unit = "K")=341"outlet temperature of glycol";
parameter Real t2(unit = "K")=335"Outlet temperature of  toluene";
parameter Real t1(unit = "K")=303"Inlet temperature of  toluene";
parameter Real D1(unit = "m")=0.043"Outer dia of inner pipe";
parameter Real D2(unit = "m")=0.064"Inside dia of outer pipe";
parameter Real k2(unit = "W/m.K")=0.146"Thermal conductivity For toluene ";
parameter Real Cp2(unit = "J/kg.K")=1.8*10^3"Specific heat capacity";
parameter Real x(unit = "m")=0.003"Wall thickness ";
Real dT1(unit = "K")"Temperature gradient ";
Real dT2(unit = "K")"Temperature gradient ";
Real Ai(unit = "sq m")"Area";
Real me_dot1(unit = "kg/s")"Mass flowrate ";
Real G(unit="kg/sq m.s")"Mass velocity";
Real Cp1(unit = "J/kg.K")"Specific heat capacity";
Real Nre"Reynolds number";
Real Npr"Prandtl number";
Real Nnu"Nusselt number";
Real hi(unit = "W/sq m.K")"Convective heat transfer coefficient";
Real mt_dot(unit = "kg/s")"Mass flowrate";
Real De(unit = "m")"Equivalent diameter ";
Real Aa(unit = "sq. m)")"Area of cross section of flow";
Real Ga(unit="kg/(sq m.s)")"Mass velocity";
Real mu2(unit="Pa.s")"Viscosity of toluene ";
Real Nret"Reynolds number";
Real Nprt"Prandtl number";
Real Nnut"Nusselt number";
Real ho(unit="W/(sq m.K)")" Convective heat transfer coefficient";
Real Dw(unit = "m")"Log mean diameter";
Real Uo(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real dTlm(unit = "K")"Log mean temperature differnce";
Real Q(unit = "W")"Rate of heat transfer";
Real L(unit = "m")"Length";
equation
Cp1=Cp*10^3;
me_dot1=me_dot/3600;          
Ai=(pi/4)*Di^2;        
G=me_dot1/Ai;             
Nre=Di*G/mu;             
Npr=Cp1*mu/k;   
////Nre is greater than 10,000,Use Dittus-Boelter eqn:
Nnu=0.023*(Nre^0.8)*(Npr^0.3);      
hi=k*Nnu/Di;                
mt_dot=(me_dot*Cp*(T2-T1)/(Cp2*10^(-3)*(t2-t1)))/3600;                      
De=(D2^2-D1^2)/D1;           
Aa=pi/4*(D2^2-D1^2);        
Ga=mt_dot/Aa;                    
mu2=4.4*10^(-4);                    
Nret=De*Ga/mu2;            
Nprt=Cp2*mu2/k2;         
Nnut=0.023*(Nret^0.8)*(Nprt^0.4);       
ho=k2*Nnut/De;                    
Dw=(D1-Di)/log(D1/Di);             
Uo=1/(1/ho+(1/hi)*(D1/Di)+(x*D1/(46.52*Dw)));
dT1=T1-t1;
dT2=T2-t2;
dTlm=(dT1-dT2)/log(dT1/dT2);                 
Q=me_dot1*Cp*(T2-T1)*1000;              
L=Q/(Uo*pi*D1*dTlm);   
//Ans. may vary slightly due to approximation. 
end Ex5_3;
