model Ex5_6
parameter Real Cph(unit = "J/(kg.K)")=4187"Sp heat of Hot ";
parameter Real mh_dot(unit = "kg/s")=600/3600"Hot side flow rate ";
parameter Real mc_dot(unit = "kg/s")=1500/3600"cold side flow rate";
parameter Real T1(unit = "K")=343"Inlet  temperature of Hot fluid";
parameter Real T2(unit = "K")=323"Outlet temperature of Hot fluid ";
parameter Real t1(unit = "K")=298"inlet Temperature of cold  fluid ";
parameter Real dT1(unit = "K")=45"Temperature gradient ";
parameter Real dT2(unit = "K")=17"Temperature gradient ";
parameter Real hi(unit = "W/sq m.K")=1600"Heat transfer coeff ";
Real Cpc(unit = "J/kg.K")"Specific heat capacity of cold";
Real Q(unit = "W")"Rate of heat transfer";
Real t2(unit = "K")"outlet Temperature of cold  fluid ";
Real dTlm(unit = "K")"Log mean temperature difference";
Real ho(unit = "W/sq m.K")"Heat transfer co-efficient";
Real U(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real A(unit = "sq m")"Area";
Real h(unit ="W/sq.m.K")"Heat transfer co-efficient";
Real c(unit = "W/K")"Heat capacity rate of cold fluid";
Real C"Capacity ratio";
Real E"Effectiveness";
Real ntu"Number of transfer units";
Real A2(unit = "sq m")"Area";
Real t2_1(unit = "K")"Outlet temperature of cold water";
equation
Cpc=Cph;             
Q=mh_dot*Cph*(T1-T2);    
t2=(mh_dot*Cph*(T1-T2))/(mc_dot*Cpc)+t1; 
dTlm=(dT1-dT2)/log(dT1/dT2);        
ho=hi;          
U=1/(1/hi+1/ho);    
A=Q/(U*dTlm);        
//hot water:
h=mh_dot*Cph;            
c=mc_dot*Cpc;            
//Heat capacity rate of hot fluid is small
C=mh_dot*Cph/(mc_dot*Cpc);       //
E=(T1-T2)/(T1-t1);      
//for paralell flow:
ntu=-log(1-E*(1+C))/(1+C);       
A2=(ntu*mh_dot*Cph)/U;    
t2_1=C*(T1-T2)+t1;        
end Ex5_6;
