model Ex5_7
import Modelica.Constants.*;
parameter Real mw_dot(unit = "kg/s")=10"Water flow rate ";
parameter Real Cpw(unit = "kJ/(kg.K)")=4.187"Specific heat capacity of water";
parameter Real t2(unit = "K")=318"Outlet Temperature of water";
parameter Real t1(unit = "K")=295"Inlet Temperature of water";
parameter Real dT1(unit = "K")=98"Temperature gradient ";
parameter Real dT2(unit = "K")=75"Temperature gradient ";
parameter Real hi(unit = "W/sq m.K")=850"Convective Heat transfer Coefficient";
parameter Real id(unit = "m")=0.027"Inside dia";
parameter Real od(unit = "m")=0.031"Outside dia";
parameter Real ho(unit = "W/sq m.K")=6000"Heat transfer coefficients";
parameter Real L(unit = "m")=4"Length ";
Real Q(unit = "W")"Rate of heat transfer";
Real dTlm(unit = "K")"Log mean temperature difference";
Real hio(unit = "W/sq.m.K")"Convective heat transfer coefficient referred to OD";
Real Uo(unit = "W/sq m.K")"Overall heat transfer co-efficient";
Real Ao(unit = "sq m")"Area";
Real n"No. of tubes";
equation
Q=mw_dot*Cpw*(t2-t1)*1000;    
dTlm=(dT1-dT2)/log(dT1/dT2);         
hio=hi*id/od;            
Uo=1/(1/ho+1/hio);       
Ao=Q/(Uo*dTlm);          
n=Ao/(pi*od*L);         
end Ex5_7;
