model Ex5_9
import Modelica.Constants.*;
parameter Real k(unit = "W/m.K")=0.628"Thermal conductivity";
parameter Real rho(unit = "kg/m^3")=980"Density";
parameter Real mu(unit="kg/(m.s)")=6*10^(-4)"Viscocity";
parameter Real Cpw(unit = "kJ/(kg.K)")=4.187"Specific heat capacity ";
parameter Real Di(unit = "m")=25/1000"Inner Dia.";      
parameter Real ho(unit = "W//sq m.K")=6000"Convective heat transfer coeficient";
parameter Real Do(unit = "m")=0.028"Outer Dia.";
parameter Real k2(unit = "W/m.K")=348.9"thermal conductivity of metal";
parameter Real t1(unit = "K")=303"Inlet temperature of water";
parameter Real t2(unit = "K")=343"Outlet temperature of water";
parameter Real Ts(unit = "K")=393"Surface Temperature";
Real Cp(unit = "J/(kg.K)")"Specific heat capacity ";
Real mw_dot(unit = "kg/s")"Mass flow rate of water ";
Real Ai(unit="sq.m")"Inside area of tube";
Real G(unit="kg/m^2.s")"mass velocity";
Real Nre"Reynolds number";
Real Npr"Prandtl number";
Real Nnu"Nusselt number";
Real hi(unit = "W/sq m.K")"Convective heat transfer coeficient";
Real Dw(unit = "m")"Diamter";
Real x(unit = "m")"Wall thickness";
Real Uo(unit = "W/sq m.K")"Overall heat transfer coefficient";
Real Q(unit = "W")"Rate of heat transfer";
Real dT1(unit = "K")"Temperature gradient ";
Real dT2(unit = "K")"Temperature gradient ";
Real dTlm(unit = "K")"Log mean temperature differnce";
Real Ao(unit = "sq m")"Area";
Real L(unit="m")"Length";
equation
Cp=Cpw*10^3;     
mw_dot=(1200*10^(-3)*rho)/3600;        
Ai=(pi*Di^2)/4;              
G=mw_dot/Ai;                
Nre=Di*G/mu;                
Npr=Cp*mu/k;                 
//Inside heat transfer coefficient
Nnu=0.023*Nre^0.8*Npr^0.4;      
hi=Nnu*k/Di;            
Dw=(Do-Di)/log(Do/Di);       
x=(Do-Di)/2;                
Uo=1/((1/ho)+(1/hi)*(Do/Di)+(x/k2)*(Do/Dw));  
Q=mw_dot*Cpw*(t2-t1)*1000;              
dT1=Ts-t1;                   
dT2=Ts-t2;                   
dTlm=(dT1-dT2)/log(dT1/dT2);     
Ao=Q/(Uo*dTlm);          
L=Ao/(pi*Do);           
end Ex5_9;
