model Ex6_15
import Modelica.Constants.*;
parameter Real m1_dot(unit = "kg/h")=5000"Mass flowarte of solution";
parameter Real ic(unit = "%")=0.1"Initial concentration";
parameter Real fc(unit = "%")=0.5"Final concentration";
parameter Real P(unit = "kN/sq m")=357"Steam pressure";
parameter Real Ts(unit = "K")=412"Steam temperature";
parameter Real H(unit = "kJ/kg")=2732"enthalpy ";
parameter Real lambda(unit = "kJ/kg")=2143"latent heat of condensing steam";
parameter Real bpr(unit = "K")=18.5"Boiling point rise";
parameter Real Hf(unit = "kJ/kg")=138"enthalpy of feed";
parameter Real lambda_s(unit = "kJ/kg")=2143"latent heat of condensing steam";
parameter Real Hv(unit = "kJ/kg")=2659"enthalpy of vapour";
parameter Real H1(unit = "kJ/kg")=568"enthalpy ";
parameter Real hi(unit = "W/sq m.K")=4500"Inside haet transfer coefficient";
parameter Real ho(unit = "W/sq m.K")=9000"Outside heat transfer coefficient";
parameter Real Do(unit = "m")=0.032"OD";
parameter Real Di(unit = "m")=0.028"ID";
parameter Real x2(unit = "m")=0.25*10^(-3)"Thickness";
parameter Real L(unit = "m")=2.5"Length";
parameter Real k1(unit = "W/sq m.K")=45"conductivity for Tube material ";
parameter Real k2(unit = "W/m.K")=2.25"For scale";
Real mf_dot(unit = "kg/h")"[kg/h] of feed solution";
Real mv_dot(unit = "kg/h")"Water evaporated";
Real T_dash(unit = "K")"Tempearture";
Real ms_dot(unit="kg/h")"[kg/h] of steam";
Real eco"Economy";
Real dT(unit = "K") "Temperature gradient";
Real x1(unit = "m")"Thickness";
Real Dw(unit = "m")"Log Mean diameter";
Real hio(unit = "W/sq m.K")"Inside haet transfer coefficient ";
Real Uo(unit="W/sq m.K")"Overall heat transfer coeff";
Real Q(unit = "W")"Rate of heat transfer";
Real A(unit = "sq m")"Area";
Real n"Number of tubes";
equation
mf_dot=(fc/ic)*m1_dot;       
mv_dot=mf_dot-m1_dot;       
T_dash=352+bpr;     
ms_dot=(mv_dot*Hv+m1_dot*H1-mf_dot*Hf)/lambda_s;        
eco=mv_dot/ms_dot;       
dT=Ts-T_dash;        
x1=(Do-Di)/2;       
Dw=(Do-Di)/log(Do/Di);    
hio=hi*(Di/Do);       
Uo=1/(1/ho+1/hio+(x1*Dw)/(k1*Do)+(x2/k2));    
Q=ms_dot*lambda_s*1000/3600;         
A=Q/(Uo*dT);            
n=A/(pi*Do*L);         
//Calculation in book is wrong from hio
end Ex6_15;
