model Ex6_3
parameter Real ic=0.05"Initial concentration";
parameter Real fc=0.2"Final concentration   ";
parameter Real T_dash(unit = "K")=373"B.P of water ";
parameter Real bpe(unit = "K")=5"Boiling point elevation";
parameter Real mf_dot(unit = "kg/h")=5000" feed to evaporator";
parameter Real lambda_s(unit = "kJ/kg")=2185"Latent heat of condensation of steam";
parameter Real lambda_v(unit = "kJ/kg")=2257"Latent heat of vaporisation of water ";
parameter Real Tf(unit = "K")=298"Temperature of feed ";
parameter Real Cpf(unit = "kJ/kg.K")=4.187"Sp. heat of feed in";
parameter Real Ts(unit = "K")=399"Saturation temperature of steam in" ;
parameter Real U(unit = "W/sq m.K")=2350"Overall heat transfer coefficient";
Real mdash_dot(unit = "kg/h")"Solute in thick liquor";
Real mv_dot(unit = "kg/h")"Water evaporated ";
Real lambda(unit = "kJ/kg")"Latent heat of vaporisation of water ";
Real T(unit = "K")"Temperature of thick liquor";
Real ms_dot(unit = "kg/h")"Steam consumption";
Real Eco"Economy of evaporator";
Real dT(unit = "K")"Temperature driving force  ";
Real Q(unit = "J/s")"Rate of heat transfer";
Real A(unit = "sq m")"Heat transfer area ";
equation
//Material balance of solute
mdash_dot=ic*mf_dot/fc;      
//Overall material balance
mv_dot=mf_dot-mdash_dot;      
lambda=lambda_v;     
T=T_dash+bpe;       
//Heat balance over evaporator=ms_dot
ms_dot=(mf_dot*Cpf*(T-Tf)+mv_dot*lambda)/lambda_s;   
Eco=mv_dot/ms_dot;       
dT=Ts-T;            
Q=ms_dot*lambda_s*1000/3600;          
A=Q/(U*dT);              
end Ex6_3;
