model Ex6_5
parameter Real m_dot(unit = "kg/h")=5000"Feed to the evaporator ";
parameter Real ic=0.10"Initial concentration";
parameter Real fc=0.4"Final concentration";
parameter Real lambda_s(unit = "kJ/kg")=2162"Latent heat of condensing steam ";
parameter Real bp(unit = "K")=373"Boiling point of solution";
parameter Real Ts(unit = "K")=407"Saturation Temperature";
parameter Real Hv(unit = "kJ/kg")=2676"Enthalpy of water vapor ";
parameter Real H_dash(unit = "kJ/kg")=419"Enthalpy of product";
parameter Real Hf(unit = "kJ/kg")=170"Enthalpy of feed";
parameter Real U(unit = "W/sq m.K")=1750"Overall Heat transfer coefficient";
Real dT(unit = "K") "Temperature gradient";
Real mdash_dot(unit = "kg/h")"kg/h of thick liquor";
Real mv_dot(unit = "kg/h")"Water evaporated ";
Real ms_dot(unit = "kg/h")"Steam consumption ";
Real eco"Steam economy of evaporator";
Real Q(unit = "W")"rate of heat transfer";
Real A(unit = "sq m")"Area";
equation
mdash_dot=m_dot*ic/fc;          
mv_dot=m_dot-mdash_dot;          
ms_dot=(mv_dot*Hv+mdash_dot*H_dash-m_dot*Hf)/lambda_s;         
eco=mv_dot/ms_dot;           
Q=ms_dot*lambda_s*1000/3600;
dT=Ts-bp;            
A=Q/(U*dT);                  
end Ex6_5;
