model Ex6_9
parameter Real Tf(unit = "K")=298"Feed temperature";
parameter Real T_dash(unit = "K")=373"temperature";
parameter Real Cpf(unit = "kJ/kg.K")=4"Specific heat of feed ";
parameter Real fc=0.2"Final concentration of salt";
parameter Real ic=0.05"Initial concentration";
parameter Real mf_dot(unit = "kg/h")=20000"Feed to evaporator";
parameter Real lambda_s(unit = "kJ/kg")=2185"latent heat of condensing steam";
parameter Real lambda(unit = "kJ/kg")=2257"latent heat of vaporisation of water ";
parameter Real bpr(unit = "K")=7"Boiling point rise";
parameter Real Ts(unit = "K")=39"Temperature of condensing steam";
Real mdash_dot(unit = "kg/h")"Thick liquor";
Real mv_dot(unit = "kg/h")"Water evaporated ";
Real T(unit = "K")"Boiling point of solution ";
Real ms_dot(unit = "kg/h")"Steam consumption ";
Real eco"Economy of evaporator";
Real Q(unit = "W")"Rate of Heat Transfer";
equation
mdash_dot=ic*mf_dot/fc;      
mv_dot=mf_dot-mdash_dot;    
T=T_dash+bpr;     
ms_dot=(mf_dot*Cpf*(T-Tf)+mv_dot*lambda)/lambda_s;   
eco=mv_dot/ms_dot;           
Q=ms_dot*lambda_s*1000/3600;
// Value of Q is wrongly mentioned in Book               
end Ex6_9;
