model Ex2_10
parameter Real A(unit="sq.m")=1"Heat transfer area"; 
parameter Real x1(unit="m")=0.15"thickness of silica brick";
parameter Real x2(unit="m")=0.01"thickness of metal";
parameter Real x4(unit="m")=0.15"thickness of air gap";
parameter Real T1(unit="K")=973"Temperature on inside edge of wall ";  
parameter Real T2(unit="K")=288"Temperature on outside  edge of wall";  
parameter Real k1(unit="W/(m.K)")=1.75"Thermal conductivity for silica brick ";  
parameter Real k2(unit="W/(m.K)")=16.86"Thermal conductivity for steel ";
parameter Real k3(unit="W/(m.K)")=0.033"Thermal conductivity for air";
parameter Real k4(unit="W/(m.K)")=5.23"Thermal conductivity for magnesite brick";
parameter Real Q1(unit="W/sq m")=1163"Heat loss"; 
Real dT(unit="K")"Temperature difference" ;
Real sR(unit="K/W")"Resistance in absence of air gap";
Real Q(unit="W/sq.m")"Heat loss per m2";
Real sR1(unit="K/W")"Resistance in presence  of air gap";
Real w(unit="mm")"width of air gap";
equation
dT=T1-T2; 
sR=(x1/k1*A)+(x2/k2*A)+(x4/k4*A);
Q= dT/sR;
sR1=dT/Q1;
w=(sR1-sR)*k3*A*1000;  
end Ex2_10;
