model Ex2_13
import Modelica.Constants.*;
parameter Real L(unit="m")=1"length of pipe";  
parameter Real k1(unit="W/(m.K)")=43.03"Thermal conductivity of steel";  
parameter Real k2(unit="W/m.K")=0.07"Thermal conductivity of insulation";   
parameter Real T1(unit="K")=423"Surface temperature on the inside of pipe";    
parameter Real T2(unit="K")=305"Surface temperature on the outside of pipe";    
parameter Real r1(unit="m")=0.0525"inner radius of steel pipe";   
parameter Real r2(unit="m")=0.0575"outer radius of steel pipe";   
parameter Real r3(unit="m")=0.1075" radius of insulation"; 
parameter Real id(unit="m")=0.105;  
Real Q(unit="W/m")"Heat Loss";
Real T(unit="K")"Temperature at the outer surface of stel pipe";
Real A(unit = "sq m")"inside area in [sq m]";
Real C(unit="W/K")"conductance per length";
equation
Q=(2*pi*L*(T1-T2))/(((log(r2/r1))/k1)+((log(r3/r2))/k2));     //Heat loss per metre 
T=T1-(Q*log(r2/r1))/(k1*2*pi*L);
A=pi*id*1;  
C=Q/(A*(T1-T2));   
end Ex2_13;
