model Ex2_16
import Modelica.Constants.*;
parameter Real d1(unit = "mm")=40" Diameter of pipe";
parameter Real t1(unit = "m")=20/1000"Insulation 1 thickness  ";
parameter Real L(unit = "m")=1"Legnth of pipe";//Assummed
parameter Real T1(unit = "K")=10"Temperature of inner surface of pipe";
parameter Real T2(unit = "K")=5"Temperature of outer surface of insulation";
parameter Real k=1"Thermal conductivity";
Real r1(unit = "m")"Outside radius ";
Real t2(unit = "m")"Insulation 2 thickness ";
Real r2(unit = "m")"radius after 1st insulation";
Real r3(unit = "m")"Radius after 2nd insulation";
Real k1(unit="w/m.K")"Thermal conductivity";
Real k2(unit="w/m.K")"Thermal conductivity";
Real Q1(unit="w")"Heat loss by laye-1";
Real Q2(unit="w")"Heat loss by laye-2";
Real per_red(unit="%")"Percent reduction";
equation
r1=(d1/2)/1000; 
t2=t1;         
r2=r1+t1;     
r3=r2+t2;     
k1=k;        //For M-1 material
k2=3*k;      //For material M-2
Q1=(T1-T2)/(log(r2/r1)/(2*22/7*L*k1)+log(r3/r2)/(2*22/7*L*k2));
Q2=(T1-T2)/(log(r2/r1)/(2*22/7*L*k2)+log(r3/r2)/(2*22/7*L*k1));
per_red=(Q2-Q1)*100/Q2;
end Ex2_16;
