model Ex2_17
import Modelica.math.*;
import Modelica.Constants.*;
parameter Real T1(unit="K")=523"Temperature inside steel pipe"; 
parameter Real T2(unit="K")=323"Temperature outside steel pipe";  
parameter Real r1(unit="m")=0.05"inner Radius of steel pipe";
parameter Real r2(unit="m")=0.055"outer  Radius of steel pipe";
parameter Real t(unit="m")=0.05"Thickness of insulation";      
parameter Real k1(unit="W/(m.K)")=50"Thermal conductivity of steel pipe";     
parameter Real k2(unit="W/(m.K)")=0.06"Thermal conductivity of first insulation";   
parameter Real k3(unit="W/(m.K)")=0.12"Thermal conductivity of second insulation";   
Real r3(unit="m")"Radius of first layer of insulation";
Real r4(unit="m")"Radius of second layer of insulation";  
Real Q_by_L1(unit="W/m")"Heat loss";
Real Q_by_L2(unit="W/m")"Heat loss";
Real perct(unit="%")"percent reduction in heat loss";
equation
r3=r2+t;
r4=r3+t;
Q_by_L1=2*pi*(T1-T2)/((log(r2/r1))/k1+(log(r3/r2))/k2+(log(r4/r3))/k3);  
Q_by_L2=2*pi*(T1-T2)/((log(r2/r1))/k1+(log(r3/r2))/k3+(log(r4/r3))/k2);
perct=(Q_by_L2-Q_by_L1)*100/Q_by_L1;
end Ex2_17;
