model Ex2_26
parameter Real id(unit = "m")=0.1"internal diameter ";
parameter Real od(unit = "m")=0.12"outer diameter ";
parameter Real T1(unit = "K")=358"Temperature of fluid   ";
parameter Real T2(unit = "K")=298"Temperature of surrounding   ";
parameter Real t(unit = "m")=0.03"thickness of insulation    ";
parameter Real k1(unit = "W/m.K")=58"K for pipe material";
parameter Real k2(unit = "W/m.K")=0.2"K for  insulating material";
parameter Real h1(unit = "W/sq m .K")=720"inside heat transfer coeff ";
parameter Real h2(unit = "W/sq m .K")=9"Outside heat transfer coefficient";
Real r1(unit = "m")"internal radius";
Real r2(unit = "m")"outer radius ";
Real r3(unit = "m")"radius of insulation";
Real Q_by_L(unit="W/m")"Heat loss per meter";
equation
r1=id/2;    
r2=od/2;    
r3=r2+t;    
//Heat loss per meter=Q_by_L
Q_by_L=(T1-T2)/((1/(2*22/7*r1*h1))+(log(r2/r1)/(2*22/7*k1))+(log(r3/r2)/(2*22/7*k2))+(1/(2*22/7*r3*h2))); 
end Ex2_26;
