model Ex2_28
parameter Real A(unit = "sq m")=1"Area";
parameter Real x1(unit = "m")=0.006"Thickness of steel plate";
parameter Real x2(unit = "m")=0.075"Thickness of fire brick";
parameter Real x3(unit = "m")=0.2"Thickness of common brick";
parameter Real k1(unit = "W/m.K")=39"K for steel plate";
parameter Real k2(unit = "W/m.K")=1.1"K for fire brick";
parameter Real k3(unit = "W/m.K")=0.66"K for common brick";
parameter Real h0(unit = "W/(m^2.K)")=65"Outside heat transfer coefficient ";
parameter Real T1(unit = "K")=900"Temperature of mild steel";
parameter Real T2(unit = "K")=300"Temperature of Outside air";
Real sigma_R(unit = "K/W")"Resistance";
Real Q(unit = "W/sq m")"heat loss/sq m area";
Real T(unit = "K")"Temp of outside surface";
equation
sigma_R=(x1/(k1*A)+x2/(k2*A)+x3/(k3*A)+1/(h0*A));
//To calculate heat loss/sq m area
Q=(T1-T2)/sigma_R;    
T=Q/(A*h0)+T2;   
end Ex2_28;
