model Ex2_32
parameter Real T1(unit = "K")=798"Hot gas temperature";
parameter Real T2(unit = "K")=298"cool air temperature";
parameter Real x1(unit = "m")=0.02"Thickness of steel plate";
parameter Real k1(unit = "W/m.K")=60"K for steel plate";
parameter Real k2(unit = "W/m.K")=0.1"K for insulation";
parameter Real hi(unit = "W/sq m .K")=100"Inside heat transfer coefficient";
parameter Real h0(unit = "W/sq m .K")=25" Outside heat transfer coefficient";
Real x2(unit="m")"Thickness for insulation ";
Real Q_by_A(unit="W/sq m")"Heat flux across the layers";
Real T(unit = "K")"interfacial temperature between steel plate and insulating material";
equation
x2=x1;    
Q_by_A=(T1-T2)/(1/hi+x1/k1+x2/k2+1/h0);    
T=Q_by_A*(x2/k2+1/h0)+T2;
end Ex2_32;
