model Ex2_33
parameter Real T1(unit = "K")=2273"Temperature of hot gas";
parameter Real T4(unit = "K")=318"Ambient air temperature";
parameter Real Qr1_by_A(unit = "kW/m^2")=23.260"Heat flow by radiation from gases to inside surface of wal";
parameter Real hi(unit = "W/m^2.K")=11.63"Heat tRansfer coefficient on the inside the wall";
parameter Real K(unit = "W/m^2.K")=58"Thermal conductivity of wall:";
parameter Real Qr4_by_A(unit = "W/sq m")=9300"Heat flow by radiation from gases to inside surface of wall";
parameter Real T2(unit = "K")=1273"Inside wall temperature";
parameter Real A(unit="sq m")=1"Area";
Real Qr1(unit="W")"Radiation heat flow";
Real Qc1(unit="W")"Heat flow by convection";
Real R(unit="K/W sq.m")"Thermal Resistance";
Real Q_enter(unit="W")"Heat entering wall";
Real T3(unit="K")"Temperature";
Real Qc4_by_A(unit="W/sq.m")"Heat loss by convection";
Real h0(unit = "W/sq.m.K")"Convective conductance" ;
equation
Qr1=Qr1_by_A*A*1000;    
Qc1=hi*(T1-T2)*A;    
R=1/K;    
Q_enter=Qr1+Qc1;   
T3=T2-Q_enter*R;    
//Heat loss due to convection:
Qc4_by_A=Q_enter-Qr4_by_A;   
h0=Qc4_by_A/(T3-T4);   
end Ex2_33;
