model Ex2_34
import Modelica.Constants.*;
import Modelica.maths.*; 
parameter Real K(unit = "W/m^2.K")=0.17"Thermal conductivity of insulation";
parameter Real T2(unit = "K")=293"Temperature of room air";
parameter Real T1(unit = "K")=473"Pipe surface temperature";
parameter Real h(unit = "W/sq m.K")=3"Heat tRansfer coefficient on the inside the wall";
parameter Real D(unit = "m")=50/1000"Diameter of pipe";
parameter Real Kf(unit = "W/m.K")=0.04"Thermal conductivity of fibre glass";
Real rc(unit="m")"Critical radius";
Real ri(unit="m")"inside radius of insulation";
Real Q_by_l(unit="W/m")"Heat transfer by insulation";
Real Q_by_l1(unit="W/m")"Heat transfer without insulation";
Real per(unit="%")"Increase in heat transfer";
Real rc1(unit="m")"Critical radius";
equation
rc=K/h;
ri=D/2;
Q_by_l=(2*pi*(T1-T2))/((log(rc/ri)/K)+1/(rc*h));
//Without insulation
Q_by_l1=h*(2*pi*ri)*(T1-T2);
per=((Q_by_l-Q_by_l1)/Q_by_l1)*100;
rc1=Kf/h;
//Addition of fibre galss insulation would cause decrease in heat transfer .
end Ex2_34;
