model Ex2_41
parameter Real rho(unit = "kg/cubic m")=9000"Density";
parameter Real Cp(unit="J/(kg*K")=0.38*10^3"Cp for plate";
parameter Real k(unit = "W/m.K")=370"K for plate";
parameter Real T0(unit = "K")=483"Initial temperature of plate";
parameter Real T_inf(unit = "K")=373" temperature of air";
parameter Real delta_T(unit = "K")=40"Tempearure gradient";
parameter Real t(unit = "seconds")=5*60"time";
parameter Real x(unit = "m")=0.015"Thickness";
Real T(unit="K")"Required temperature ";
Real th(unit="m")"thickness of slab";
Real h(unit = "W/sq m.K")"Convection heat transfer coefficient";
equation
T=T0-delta_T;   
th=2*x;    
h=-rho*Cp*x*log((T-T_inf)/(T0-T_inf))/t;
end Ex2_41;
