model Ex2_42
parameter Real rho(unit = "kg/cubic m")=7800"Density";
parameter Real h(unit = "W/sq m.K")=100"Convective heat transfer coeff";
parameter Real Cp(unit="J/(kg*K")=460"Cp for rod";
parameter Real k(unit = "W/m.K")=40"K for rod";
parameter Real L(unit = "m")=1" length ofrod";
parameter Real D(unit = "m")=10/1000"diameter ";
parameter Real R(unit = "m")=D/2"raidus ";
parameter Real T(unit = "K")=473"Required Temperature";
parameter Real T_inf(unit = "K")=393" temperature of liquid";
parameter Real T0(unit = "K")=593"Temperature of rod";
Real A(unit = "sq m")"Area ";
Real V(unit = "cubic m")"Volume ";
Real L_dash(unit = "m")"Characterstic length";
Real Nbi"Biot;s No.";
Real t(unit = "sec")"Time to achieve the desired temperature";
equation
//For cylindrical rod:
A=2*22/7*R*L;    
V=22/7*R^2*L;    
L_dash=V/A;    
Nbi=h*L_dash/k;    
//N_bi<0.10,Hence lumped heat capavity is possible
t=-rho*Cp*V*log((T-T_inf)/(T0-T_inf))/(h*A);
end Ex2_42;
