package Ex2_45

  model Ex2_45_a
  parameter Real T_inf(unit = "K")=390"Temperature of steam ";
  parameter Real U(unit = "W/sq m.K")=600"Overall Heat transfer coefficient";
  parameter Real Ac(unit = "sq m")=1"Area of coil";
  parameter Real m(unit = "kg")=1000"Mass of reactor";
  parameter Real Cp(unit = "J/kg.K")=3.8*10^3"Specific heat capacity";
  parameter Real To(unit = "K")=290"Initial Temperature";
  parameter Real T(unit = "K")=360"Final  Temperature";
  Real t(unit = "sec")"Time to achieve the desired temperature";
  equation
  //Heat gained from the steam=Rate of increase of internal energy
  //U*A*(T_inf-T)=m*Cp*dT
      log((T_inf-To)/(T_inf-T))=U*Ac*t/(m*Cp);
  end Ex2_45_a;

  model Ex2_45_b
  parameter Real U(unit = "W/sq m.K")=600"Overall Heat transfer coefficient";
  parameter Real Ac(unit = "sq m")=1"Area of coil";
  parameter Real T_inf(unit="K")=390"Steam Temperature";               
  parameter Real h(unit = "W/sq m.K")=8.5"Outside heat transfer coefficient";
  parameter Real Av(unit="sq.m")=10"Vessel Area";
  parameter Real To(unit = "K")=290"Initial Temperature";
  parameter Real T(unit = "K")=360"Final  Temperature";                 
  parameter Real m(unit = "kg")=1000"Mass of reactor";
  parameter Real Cp(unit = "J/kg.K")=3.8*10^3"Specific heat capacity";
  Real a;
  Real b;
  Real t(unit = "sec")"Time to achieve the desired temperature";
  Real T_max(unit="K")"Max Temperature";
  equation
  //Heat gained from the steam - Heat loss to surrounding = Rate of increase of internal energy
  //U*Ac*T_inf-T) - h*Av(T-To)=m*Cp*dT/dt --------- Eq1
    a = U * Ac * T_inf + h * Av * To;
  b=U*Ac + h*Av;
  t=(-m*Cp/b)*log((a-b*T)/(a-b*To));
  // On integrating Eq1
  //Rate of flow to reactants = Rate of heat flow to surroundings
    U * Ac * (T_inf - T_max) = h * Av * (T_max - To);
  end Ex2_45_b;























end Ex2_45;
