model Ex2_47
parameter Real k(unit = "W/m.K")=200"k for aluminium";
parameter Real h(unit = "W/sq m.K")=15"convective coeff ";
parameter Real T0(unit = "K")=523"Temperature of rod";
parameter Real T_inf(unit = "K")=288"Air temperature";
parameter Real dia(unit = "m")=25/1000"diameter";
parameter Real L(unit = "m")=100/1000"length of rod ";
Real theta_0(unit = "K")"Temperature Gradient";
Real r(unit = "m")"radius";
Real P(unit = "m")"Perimeter";
Real A(unit = "sq m")"Area ";
Real m"constant";
Real Q(unit="W")"Heat loss ";
Real nf(unit="m")"Fin efficiency for  insulated fin";
Real T(unit = "K")"Temperature at end of fin";
equation
theta_0=T0-T_inf; 
r=dia/2;    
P=22/7*dia;    
A=22/7*r^2;    
//For insulated fin:
m=sqrt(h*P/(k*A));
Q=theta_0*tanh(m*L)*sqrt(h*P*k*A);    
nf=tanh(m*L)/(m*L);    
//At the end of the fin: theta/theta_0=(cosh[m(L-x)]/cosh(mL))
//at x=L, theta/theta_0=1/(cosh(mL)
T=T_inf+(T0-T_inf)*(1/cosh(m*L));    
end Ex2_47;
