package Ex2_49
  model Ex2_49_I
  import Modelica.Math.*;
  parameter Real k(unit = "W/m.K") = 300"K for pin ";
  parameter Real h(unit = "W/sq m.K") = 20 "convective coeff ";
  parameter Real P(unit = "m") = 0.05 "Perimeter";
  parameter Real A(unit = "sq m") = 2 / 10000 "Area";
  parameter Real T0(unit = "K") = 503 "Temperature of hot surface";
  parameter Real T_inf(unit = "K") = 303 "Temperature of Surrounding";
  parameter Real L1(unit = "m") = 0.1 "Length of fin";
  Real theta_0(unit = "K")"Temperature differnece";
  Real m"Constant";
  Real Q(unit = "W")"Rate of heat transfer for 6 fins";
  Real Q1(unit = "W")"Rate of heat transfer  ";
  equation
  theta_0 = T0 - T_inf;
  m = sqrt(h * P / (k * A));
//CASE 1:  6 Fins of 100 mm length
  Q1 = sqrt(h * P * k * A) * theta_0 * tanh(m * L1);
//For 6 fins
  Q = Q1 * 6;
  end Ex2_49_I;








  model Ex2_49_II
  import Modelica.Math.*;
  parameter Real k(unit = "W/m.K") = 300"K for pin ";
  parameter Real h(unit = "W/sq m.K") = 20 "convective coeff ";
  parameter Real P(unit = "m") = 0.05 "Perimeter";
  parameter Real A(unit = "sq m") = 2 / 10000 "Area";
  parameter Real T0(unit = "K") = 503 "Temperature of hot surface";
  parameter Real T_inf(unit = "K") = 303 "Temperature of Surrounding";
  parameter Real L2(unit = "m") = 60 / 1000 "Length";
  Real theta_0(unit = "K")"Temperature differnece";
  Real m"Constant";
  Real Q(unit = "W")"Rate of heat transfer  for 10 fins";
  Real Q2(unit = "W")"Rate of heat transfer ";
  equation
  theta_0 = T0 - T_inf;
  m = sqrt(h * P / (k * A));
  //CASE 2:  10 fins of 60 mm length
  Q2 = sqrt(h * P * k * A) * theta_0 * tanh(m * L2);
  Q = Q2 * 10;
  //10fins of 60mm length is more effective
  end Ex2_49_II;







end Ex2_49;
